import javafx.application.Application;
import javafx.scene.Scene;
import javafx.stage.Stage;

import model.GuessMyWordModel;
import view.GuessController;
import view.GuessView;

/**
 * Creates a window and ties model, view and controller together.
 */
public class Main extends Application {

    @Override
    public void start(Stage primaryStage) {

        // create model, view and controller, and tie them together
        GuessMyWordModel model = new GuessMyWordModel();
        GuessView view = new GuessView(model); // also creates the controller

        // create the window, add the view, and show it
        Scene scene = new Scene(view);
        primaryStage.setTitle("Guess My Word");
        primaryStage.setScene(scene);
        primaryStage.setResizable(false);
        primaryStage.show();
    }

    public static void main(String[] args) {
        launch(args);
    }
}
